﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace Fizyka_symulacja {
    public partial class Form1 : Form {
        #region properties
        int minX = 0;
        int maxX {
            get { 
                return pictureBox1.ClientRectangle.Right; 
            }
        }
        int minY = 0;
        int maxY {
            get { 
                return pictureBox1.ClientRectangle.Bottom; 
            }
        }
        #endregion

        #region fields
        private int lastX = -1;
        private int lastY = -1;
        private Pen animPen;
        private Graphics canvas;
        private Bitmap background;
        private bool animation = false;
        #endregion 

        #region structs
        class Pix {
            public int X;
            public int Y;
            public Pix(int x, int y) {
                this.X = x;
                this.Y = y;
            }
        }
        #endregion

        #region methods
        public Form1() {
            InitializeComponent();
        }

        private void Animate() {
            bool sthChanged = false;
            if (!animation) {
                SetStartupConditions();
                animation = true;
            }
            int sandColor = LineColor.BackColor.ToArgb();
            int objectColor = ObjectColor.BackColor.ToArgb();
            int bgColor = BGColor.BackColor.ToArgb();
            for (int y = background.Height - 1; y >= 0; y--) {
            //for (int y = 0; y < background.Height; y++) {
                for (int x = 0; x < background.Width; x++) {
                    if (background.GetPixel(x, y).ToArgb() == sandColor) {
                        Pix tmp = GeneratePosition(x, y, sandColor, objectColor, bgColor);
                        background.SetPixel(x, y, BGColor.BackColor);
                        background.SetPixel(tmp.X, tmp.Y, LineColor.BackColor);
                        if (tmp.X != x || tmp.Y != y) {
                            sthChanged = true;
                            
                        }
                    }
                }
                
            }
            canvas.Flush();
            //canvas.DrawImage(bmp, pictureBox1.DisplayRectangle);
            pictureBox1.Image = background;
            //bmp.Dispose();
            canvas.Flush();
            if (!sthChanged) {
                timer1.Stop();
                animation = false;
            }
        }
        private Pix GeneratePosition(int x, int y, int sandColor, int objectColor, int bgColor) {
            int nX = x, nY = y;

            if(y==0 || y+1 == background.Height){
                return new Pix(x,y);
            }

            if (background.GetPixel(x, y + 1).ToArgb() == bgColor) {
                //jezeli nie napotkano przeszkody
                nX = x;
                nY = y + 1;
            }
            else {
                if (background.GetPixel(x, y + 1).ToArgb() == objectColor) {
                    nX = x;
                    nY = y;
                }
                else if (background.GetPixel(x, y + 1).ToArgb() == sandColor) {
                    if (x < background.Width && background.GetPixel(x + 1, y).ToArgb() == bgColor) {//ograniczenie z prawej
                        if (background.GetPixel(x + 1, y + 1).ToArgb() == bgColor) {
                            nX = x + 1;
                            nY = y + 1;
                        }
                    }else if(x>0 && background.GetPixel(x-1,y).ToArgb() == bgColor){ // i z lewej
                        if (background.GetPixel(x - 1, y + 1).ToArgb() == bgColor) {
                            nX = x - 1;
                            nY = y + 1;
                        }
                    }
                }
            }

            return new Pix(nX,nY);
        }
        
        private void SetStartupConditions() {
            if (animPen == null || canvas == null || background == null) {
                animPen = new Pen(LineColor.BackColor, 1);
                background = new Bitmap(pictureBox1.DisplayRectangle.Width, pictureBox1.DisplayRectangle.Height);
                canvas = Graphics.FromImage(background);
                canvas.Clear(BGColor.BackColor);
            }
            int penSize = 1;
            Pen obj = new Pen(LineColor.BackColor, penSize);
            Point p = new Point(pictureBox1.DisplayRectangle.Right / 2, pictureBox1.DisplayRectangle.Bottom / 4);
            //Graphics canvas = pictureBox1.CreateGraphics();
            
            Rectangle rec = new Rectangle(p, new Size(int.Parse(ObjWidthTB.Text) , int.Parse(ObjHeightTB.Text)));
            
            //canvas.DrawEllipse(obj, rec);
            canvas.DrawRectangle(obj, rec);
            canvas.FillRectangle(obj.Brush, rec);
            canvas.Flush();
            pictureBox1.Image = background;
        }

        #endregion

        #region events
        private void pictureBox1_MouseDown(object sender, MouseEventArgs e) {
            if (animPen == null || canvas == null || background == null) {
                SetStartupConditions();
                //animPen = new Pen(LineColor.BackColor, 1);
                //background = new Bitmap(pictureBox1.Image);
                //canvas = Graphics.FromImage(background);
            }
            if (e.Button == MouseButtons.Left && !animation) {
                if (lastX == -1 || lastY == -1) {
                    lastX = e.X;
                    lastY = e.Y;
                    return;
                }
                int penSize = int.Parse(WidthTB.Text);

                Pen obj = new Pen(ObjectColor.BackColor, (float)penSize);
                Point p = new Point(e.X, e.Y);
                Point k = new Point(lastX, lastY);
                //Graphics canvas = pictureBox1.CreateGraphics();
                //canvas.Clear(BGColor.BackColor);
                canvas.DrawLine(obj, p, k);
                Rectangle rec = new Rectangle(p, new Size(penSize/2, penSize/2));
                canvas.DrawEllipse(obj, rec); // zaokraglanie rogow
                canvas.Flush();
                pictureBox1.Image = background;
                lastX = p.X;
                lastY = p.Y;
            }
            else {
                lastY = -1;
                lastX = -1;
            }
        }
        
        private void startToolStripMenuItem_Click(object sender, EventArgs e) {
            SetStartupConditions();
            timer1.Interval = int.Parse(SpeedTB.Text);
            timer1.Start();
        }

        private void LineColor_Click(object sender, EventArgs e) {
            if (!animation) {
                colorDialog1.Color = ((PictureBox)sender).BackColor;
                colorDialog1.ShowDialog();
                ((PictureBox)sender).BackColor = colorDialog1.Color;
                SetStartupConditions();
            }
        }

        private void pictureBox1_LoadCompleted(object sender, AsyncCompletedEventArgs e) {
            SetStartupConditions();
        }

        private void timer1_Tick(object sender, EventArgs e) {
            Animate();
        }

        private void Form1_Load(object sender, EventArgs e) {
            SetStartupConditions();
        }
        #endregion
    }
}
